<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="kunde-html-incl.xsl"/>
	<xsl:template match="/Kreditinstitut">
		<xsl:processing-instruction name="cocoon-format">type="text/html"</xsl:processing-instruction>
		<html>
			<head>
				<title>
					<xsl:value-of select="Name"/>
				</title>
			</head>
			<body bgcolor="#ffffff">
				<h1 align="center">
Kundendaten der <xsl:value-of select="Name"/> - <br/>Bankleitzahl <xsl:value-of select="Bankleitzahl"/>
				</h1>
				<h4 align="center">Stichtag: <xsl:value-of select="@Stichtag"/>
				</h4>
				<xsl:apply-templates select="Marktbereich"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="Marktbereich">
		<h2 align="center" color="#FF0000">
			<font color="#FF0000">
    Marktbereich: <xsl:value-of select="Name"/>
			</font>
		</h2>
		<xsl:apply-templates select="Filiale"/>
		<br/>
	</xsl:template>
	<xsl:template match="Filiale">
		<table border="0" cellpadding="5" cellspacing="2" width="100%" bgcolor="#BEDAFC">
			<tr>
				<td>
					<h3>
    Filiale: <xsl:value-of select="Name"/>
					</h3>
					<table border="0" cellpadding="3" cellspacing="0" width="100%" bgcolor="#C0C0C0">
						<tr>
							<td align="left" width="100%">
								<xsl:apply-templates select="Kunde">
									<xsl:sort select="Nachname"/>
								</xsl:apply-templates>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<br/>
	</xsl:template>
	<xsl:template match="Kunde">
		<h4>
    Name: <xsl:value-of select="Nachname"/>, <xsl:value-of select="Vorname"/>, Kundennummer: <xsl:value-of select="Kundennummer"/>
		</h4>
		<xsl:if test='Kundendatenverweis/@href!=""'>
			<xsl:variable name="link">
				<xsl:apply-templates select="Kundendatenverweis/@href"/>
			</xsl:variable>
			<xsl:apply-templates select="document($link)"/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
